/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.nvidium.renderers;

import me.cortex.nvidium.gl.shader.Shader;
import me.cortex.nvidium.gl.shader.ShaderType;
import me.cortex.nvidium.mixin.minecraft.LightMapAccessor;
import me.cortex.nvidium.renderers.Phase;
import me.cortex.nvidium.sodiumCompat.ShaderLoader;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.opengl.GL33;
import org.lwjgl.opengl.GL45;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.opengl.NVMeshShader;
import org.lwjgl.opengl.NVVertexBufferUnifiedMemory;

public class TemporalTerrainRasterizer
extends Phase {
    private final int blockSampler = GL33.glGenSamplers();
    private final int lightSampler = GL33.glGenSamplers();
    private final Shader shader = Shader.make().addSource(ShaderType.TASK, ShaderLoader.parse(new ResourceLocation("nvidium", "terrain/temporal_task.glsl"))).addSource(ShaderType.MESH, ShaderLoader.parse(new ResourceLocation("nvidium", "terrain/mesh.glsl"))).addSource(ShaderType.FRAGMENT, ShaderLoader.parse(new ResourceLocation("nvidium", "terrain/frag.frag"))).compile();

    public TemporalTerrainRasterizer() {
        GL45C.glSamplerParameteri((int)this.blockSampler, (int)10241, (int)9986);
        GL45C.glSamplerParameteri((int)this.blockSampler, (int)10240, (int)9728);
        GL45C.glSamplerParameteri((int)this.blockSampler, (int)33082, (int)0);
        GL45C.glSamplerParameteri((int)this.blockSampler, (int)33083, (int)4);
    }

    public void raster(int regionCount, long commandAddr) {
        this.shader.bind();
        int blockId = Minecraft.m_91087_().m_91097_().m_118506_(new ResourceLocation("minecraft", "textures/atlas/blocks.png")).m_117963_();
        int lightId = ((LightMapAccessor)Minecraft.m_91087_().f_91063_.m_109154_()).getTexture().m_117963_();
        GL45C.glBindTextureUnit((int)0, (int)blockId);
        GL45C.glBindSampler((int)0, (int)this.blockSampler);
        GL45C.glBindTextureUnit((int)1, (int)lightId);
        GL45C.glBindSampler((int)1, (int)this.lightSampler);
        NVVertexBufferUnifiedMemory.glBufferAddressRangeNV((int)36673, (int)0, (long)commandAddr, (long)((long)regionCount * 8L));
        NVMeshShader.glMultiDrawMeshTasksIndirectNV((long)0L, (int)regionCount, (int)0);
        GL45C.glBindSampler((int)0, (int)0);
        GL45C.glBindSampler((int)1, (int)0);
    }

    public void delete() {
        GL45.glDeleteSamplers((int)this.blockSampler);
        GL45.glDeleteSamplers((int)this.lightSampler);
        this.shader.delete();
    }
}

